#ifndef __C4DBASEBITMAP_H
#define __C4DBASEBITMAP_H

#include "ge_math.h"
#include "operatingsystem.h"

class BaseContainer;
class Filename;

class BaseBitmap
{
	private:
		BaseBitmap(void);
	public:
		BaseBitmap *GetClone(void);
		BaseBitmap *GetClonePart(LONG x, LONG y, LONG w, LONG h);
		Bool CopyTo(BaseBitmap *dst);
	
		void FlushAll(void); 
		
		LONG  GetBw (void) {	return C4DOS.Bm->GetBw(this); }
		LONG  GetBh (void) {	return C4DOS.Bm->GetBh(this); }
		LONG  GetBt (void) {	return C4DOS.Bm->GetBt(this); }
		LONG  GetBpz(void) { return C4DOS.Bm->GetBpz(this); }

		LONG  Init(const Filename &name, LONG frame=-1, Bool *ismovie=NULL);
		LONG  Init(LONG x, LONG y, LONG depth=24);
	  LONG  Save(const Filename &name, LONG format, BaseContainer *data, LONG savebits);

		void	GetLine(LONG y, void *data);
		void	SetLine(LONG y, void *data, LONG depth);
		void  SetPixelCnt	(LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc);
		void  GetPixelCnt	(LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc);
		void	GetAlphaLine(LONG y, void *data, LONG channel);
		void	SetAlphaLine(LONG y, void *data, LONG channel);
		void	SetCMAP(LONG i, LONG r, LONG g, LONG b);
		void	ScaleIt(BaseBitmap *dst, LONG intens, Bool sample, Bool nprop);
		void	SetPen(LONG r, LONG g, LONG b) { C4DOS.Bm->SetPen(this,r,g,b); }
		void	Clear(LONG r, LONG g, LONG b);
		void	Clear(LONG x1, LONG y1, LONG x2, LONG y2, LONG r, LONG g, LONG b);
		void	Line(LONG x1, LONG y1, LONG x2, LONG y2) { C4DOS.Bm->Line(this,x1,y1,x2,y2); }
		void	SetPixel(LONG x, LONG y, LONG r, LONG g, LONG b) {	C4DOS.Bm->SetPixel(this,x,y,r,g,b); }
		void	GetPixel(LONG x, LONG y, UWORD *r, UWORD *g, UWORD *b) { C4DOS.Bm->GetPixel(this,x,y,r,g,b); }
		LONG	AddChannel(Bool internal, Bool straight);
		void	RemoveChannel(LONG channel);
		void	GetAlphaPixel(LONG channel, LONG x, LONG y, UWORD *val) { C4DOS.Bm->GetAlphaPixel(this,channel,x,y,val); }
		void	SetAlphaPixel(LONG channel, LONG x, LONG y, LONG val) {	C4DOS.Bm->SetAlphaPixel(this,channel,x,y,val); }

		LONG	SaveChannel(LONG channel, const Filename &name);
		LONG	GetInternalChannel(void);
		LONG	GetChannelCount(void);
		LONG	GetChannelNum(LONG num);

		static BaseBitmap *Alloc(void);
		static void Free(BaseBitmap *&bc);
};

class MovieSaver
{
	private:
		MovieSaver(void);
	public:
		LONG Open(const Filename &name, BaseBitmap *bm, LONG fps, LONG format, BaseContainer *data, LONG savebits);
		LONG Write(BaseBitmap *bm);
		void Close(void);
		Bool Choose(LONG format, BaseContainer *bc);

		static MovieSaver *Alloc(void);
		static void Free(MovieSaver *&bc);
};

#endif
